<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON TM-U950 Slip CCF");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Nota de Envio Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,115);
	
	$fecha = explode("-",$fecha);
	$fechadia = explode(" ",$fecha[2]);
	$phpPrinter->printString($fechadia[0],2,$printer,$acum,13,11,700);
	$phpPrinter->printString($fecha[1],2,$printer,$acum,13,0,730);
	$phpPrinter->printString($fecha[0],2,$printer,$acum,13,0,750);
	//$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($cliente,0,40))),2,$printer,$acum,13,0,250);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,40))),2,$printer,$acum,13,11,250);
	$phpPrinter->tabPrinter($acum,13);
	
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString($producto->cant,2,$printer,$acum,9,7,250);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),30),2,$printer,$acum,9,0,300);
		$phpPrinter->printString($producto->costo,2,$printer,$acum,9,0,625);
		$phpPrinter->printString($producto->cant * $producto->costo,2,$printer,$acum,9,0,720);
		$phpPrinter->tabPrinter($acum,5);
	}
	
	/*Footer*/
	printer_draw_text($printer,$totales['totalTotal'], 720, 385);
	printer_draw_text($printer,"Ref:".$referencia, 500, 385);
	if($condicion=="Credito"){
		printer_draw_text($printer,"Credito a:".$diascred." dias", 500, 395);
	}
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>